<?php
/*
Template Name: Full Screen Sections
*/
?>
<?php
$hudson_edge_options = hudson_edge_return_global_options();
$hudson_edge_id = hudson_edge_get_page_id();

$hudson_edge_full_screen_holder_style = "";

if(get_post_meta($hudson_edge_id, "edgt_page_background_color", true) != ""){
    $hudson_edge_full_screen_holder_style .= "background-color:".esc_attr(get_post_meta($hudson_edge_id, "edgt_page_background_color", true)).";";
}else{
    $hudson_edge_full_screen_holder_style .= "";
}

$hudson_edge_header_bottom_appearance = 'regular';
if(isset($hudson_edge_options['header_bottom_appearance'])){
    $hudson_edge_header_bottom_appearance = $hudson_edge_options['header_bottom_appearance'];
}

$hudson_edge_enable_vertical_menu = false;
if(hudson_edge_is_side_header()){
    $hudson_edge_enable_vertical_menu = true;
}

$hudson_edge_content_style = "";
if(get_post_meta($hudson_edge_id, "edgt_content-top-padding", true) != ""){
    if(get_post_meta($hudson_edge_id, "edgt_content-top-padding-mobile", true) == 'yes'){
        $hudson_edge_content_style = "padding-top:".esc_attr(get_post_meta($hudson_edge_id, "edgt_content-top-padding", true))."px !important";
    }else{
        $hudson_edge_content_style = "padding-top:".esc_attr(get_post_meta($hudson_edge_id, "edgt_content-top-padding", true))."px";
    }
}

$hudson_edge_fs_navigation_type = "";
if(isset($hudson_edge_options['fs_navigation_slider_vertical_section_type'])){
    $hudson_edge_fs_navigation_type = $hudson_edge_options['fs_navigation_slider_vertical_section_type'];
}

?>
<?php get_header(); ?>
    <div class="full_screen_preloader">
        <?php
        if($hudson_edge_options['loading_animation'] == "on") {
            if($hudson_edge_options['loading_image'] != "") { ?>
                <div class="ajax_loader"><div class="ajax_loader_1"><div class="ajax_loader_2"><img src="<?php echo esc_url($hudson_edge_options['loading_image']) ?>" alt="<?php esc_html_e('Alt image','hudson'); ?>" /></div></div></div>
            <?php }
            else { ?>
                <div class="ajax_loader"><div class="ajax_loader_1"><?php hudson_edge_loading_spinners(); ?></div></div>
            <?php }
        }
        ?>
    </div>

    <div class="full_screen_holder"<?php hudson_edge_inline_style($hudson_edge_full_screen_holder_style); ?>>
        <div class="full_screen_inner" <?php hudson_edge_inline_style($hudson_edge_content_style); ?>>

            <?php if (have_posts()) : while (have_posts()) : the_post(); ?>

                <?php the_content(); ?>

            <?php endwhile; endif; ?>

        </div>
        <?php if($hudson_edge_fs_navigation_type == '' || $hudson_edge_fs_navigation_type == 'arrows' || $hudson_edge_fs_navigation_type == 'both'){ ?>
            <div class="full_screen_navigation_holder">
                <div class="full_screen_navigation_inner">
                    <a id="up_fs_button" href="#" target="_self"><span class='arrow_carrot-up'></span></a>
                    <a id="down_fs_button" href="#" target="_self"><span class='arrow_carrot-down'></span></a>
                </div>
            </div>
        <?php } ?>
    </div>

<?php get_footer(); ?>